/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import morph.avaritia.api.ExtremeCraftingRecipe;
import morph.avaritia.init.AvaritiaModContent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class ExtremeShapedRecipe
implements ExtremeCraftingRecipe {
    private final ResourceLocation id;
    private final String group;
    private final int width;
    private final int height;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack result;

    public ExtremeShapedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.recipeItems = recipeItems;
        this.result = result;
    }

    public boolean matches(CraftingContainer container, Level level) {
        for (int xOffset = 0; xOffset <= container.m_39347_() - this.width; ++xOffset) {
            for (int yOffset = 0; yOffset <= container.m_39346_() - this.height; ++yOffset) {
                if (this.matches(container, xOffset, yOffset, true)) {
                    return true;
                }
                if (!this.matches(container, xOffset, yOffset, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer container, int xOffset, int yOffset, boolean transpose) {
        for (int x = 0; x < container.m_39347_(); ++x) {
            for (int y = 0; y < container.m_39346_(); ++y) {
                int rx = x - xOffset;
                int ry = y - yOffset;
                Ingredient ingredient = Ingredient.f_43901_;
                if (rx >= 0 && ry >= 0 && rx < this.width && ry < this.height) {
                    ingredient = transpose ? (Ingredient)this.recipeItems.get(this.width - rx - 1 + ry * this.width) : (Ingredient)this.recipeItems.get(rx + ry * this.width);
                }
                if (ingredient.test(container.m_8020_(x + y * container.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ItemStack assemble(CraftingContainer p_44001_) {
        return this.m_8043_().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AvaritiaModContent.EXTREME_SHAPED_RECIPE.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ExtremeShapedRecipe> {
        public ExtremeShapedRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map keys = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])pattern, (Map)keys, (int)width, (int)height);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ExtremeShapedRecipe(id, group, width, height, (NonNullList<Ingredient>)ingredients, result);
        }

        @Nullable
        public ExtremeShapedRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf packet) {
            int width = packet.m_130242_();
            int height = packet.m_130242_();
            String group = packet.m_130277_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)packet));
            }
            ItemStack result = packet.m_130267_();
            return new ExtremeShapedRecipe(id, group, width, height, (NonNullList<Ingredient>)ingredients, result);
        }

        public void toNetwork(FriendlyByteBuf packet, ExtremeShapedRecipe recipe) {
            packet.m_130130_(recipe.width);
            packet.m_130130_(recipe.height);
            packet.m_130070_(recipe.group);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(packet);
            }
            packet.m_130055_(recipe.result);
        }
    }
}

